<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio de Energía</title>
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Laboratorio de Energía' />
    <meta name='description' content='El Laboratorio de Energía es una unidad de la Sección de Ingeniería Mecánica de la Pontificia Universidad Católica del Perú, cuyas principales funciones son la docencia, investigación y desarrollo tecnológico a través de servicios especializados a la industria en temas de eficiencia energética.'
    />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-energia.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Energía, unidad de la Sección de Ingeniería Mecánica,principales funciones son la docencia,investigación y desarrollo tecnológico' />
    <!-- OpenGraph Meta Tags -->
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Energía' />
    <meta property='og:description' content='El Laboratorio de Energía es una unidad de la Sección de Ingeniería Mecánica de la Pontificia Universidad Católica del Perú, cuyas principales funciones son la docencia, investigación y desarrollo tecnológico a través de servicios especializados a la industria en temas de eficiencia energética.'
    />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-energia.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Energía</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs">
                    <h1 class="visible-xs-block">Laboratorio de Energía</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="text-center">El Laboratorio de Energía tiene como principales funciones  la docencia, investigación y desarrollo tecnológico a través de servicios especializados al sector productivo en temas de eficiencia energética.</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <p>El laboratorio está especializado en las áreas de la energía térmica, fluidos, refrigeración, acondicionamiento de ambientes, medición – registro de variables térmicas y motores de combustión interna.</p>
            <br>
            <h3>Este laboratorio puede realizar:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li> Medición y registro de parámetros térmicos: temperatura, presión, caudal, humedad relativa, presión atmosférica entre las principales.</li>
                        <li> Pruebas a presión: hidrostáticas, neumáticas y de reventamiento.</li>
                        <li> Análisis energéticos en calderas.</li>
                        <li> Evaluación y diseño de plantas a vapor.</li>
                        <li> Evaluación y diseño de sistemas de refrigeración.</li>
                    </ul>
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li> Evaluación y diseño de acondicionamiento de ambientes.</li>
                        <li> Evaluación de equipos térmicos.</li>
                        <li> Calibración de instrumentos de medición.</li>
                        <li> Entrenamiento de personal técnico y profesional en equipos y sistemas térmicos.</li>
                        <li> Evaluación en motores de combustión interna.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                        <dl class="titulo"><dt>Contacto</dt>
                            <dd></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/05.png" alt="" /></dt>
                            <dd>
                                <strong>Mg. Ronald Mas Bautista</strong><br>
                                Responsable de Laboratorio<br>
                                Departamento de Ingeniería - Sección de Ingeniería Mecánica
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/02.png" alt="" /></dt>
                            <dd>(01) 626-2000 anexo 4860 | 4877 | 4885</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/03.png" alt="" /></dt>
                            <dd> <a href="mailto:laben@pucp.edu.pe">laben@pucp.edu.pe</a></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">

                        <a href="#modal_1" class="openform"><img src="img/energia/01.jpg" alt="innovapucp laboratorio energia 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/energia/01.jpg" alt="innovapucp laboratorio energia 01" />
                            <p>Análisis termográfico en una planta a vapor</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Análisis termográfico en una planta a vapor</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/energia/02.jpg" alt="innovapucp laboratorio energia 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/energia/02.jpg" alt="innovapucp laboratorio energia 02" />
                            <p>Banco demostrativo de funcionamiento de inyectores diésel</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Banco demostrativo de funcionamiento de inyectores diésel</p>
                        </div>
                    </div>

                    <div class="item">

                        <a href="#modal_3" class="openform"><img src="img/energia/03.jpg" alt="innovapucp laboratorio energia 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/energia/03.jpg" alt="innovapucp laboratorio energia 03" />
                            <p>Eficiencia energética banco de ensayos para entrenamiento de personal en una <br>planta de refrigeración a compresión a vapor</p>
                        </div>


                        <div class="carousel-caption">
                            <p>Eficiencia energética banco de ensayos para entrenamiento de personal en una planta de refrigeración a compresión a vapor</p>
                        </div>

                    </div>

                    <div class="item">

                        <a href="#modal_4" class="openform"><img src="img/energia/04.jpg" alt="innovapucp laboratorio energia 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/energia/04.jpg" alt="innovapucp laboratorio energia 04" />
                            <p>Eficiencia energética banco de ensayos para entrenamiento de personal en un ventilador centrífugo</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Eficiencia energética banco de ensayos para entrenamiento de personal en un ventilador centrífugo</p>
                        </div>

                    </div>
                    <div class="item">

                        <a href="#modal_5" class="openform"><img src="img/energia/05.jpg" alt="innovapucp laboratorio energia 05" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/energia/05.jpg" alt="innovapucp laboratorio energia 05" />
                            <p>Maqueta demostrativa de turbina de helicóptero</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Maqueta demostrativa de turbina de helicóptero</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_6" class="openform"><img src="img/energia/06.jpg" alt="innovapucp laboratorio energia 06" /></a>
                        <div id="modal_6" class="form">
                            <img class="img-responsive" src="img/energia/06.jpg" alt="innovapucp laboratorio energia 06" />
                            <p>Registro de variables térmicas y emisiones en un motor diésel</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Registro de variables térmicas y emisiones en un motor diésel</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_7" class="openform"><img src="img/energia/07.jpg" alt="innovapucp laboratorio energia 07" /></a>
                        <div id="modal_7" class="form">
                            <img class="img-responsive" src="img/energia/07.jpg" alt="innovapucp laboratorio energia 07" />
                            <p>Turbina a vapor de generación de electricidad</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Turbina a vapor de generación de electricidad</p>
                        </div>
                    </div>
                </div>

                <ol class="carousel-indicators">
                    <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="6"></li>
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="">
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">

                    <img src="img/right.png" alt="">
                </a>
            </div>
        </div>
    </div>

    <?php include 'include/otros_laboratorios.php';?>
    <?php include 'include/footer.php';?>
    <script src="js/easyResponsiveTabs.min.js"></script>


    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

    <script>
        $(document).ready(function() {
            $('.fancybox').fancybox();
            $(".openform").fancybox();
        });
    </script>

</body>

</html>
