<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio de Estructuras Antisísmicas</title> 
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Laboratorio de Estructuras Antisísmicas' />  
    <meta name='description' content='El Laboratorio de Estructuras Antisísmicas cuenta con más de 30 años dedicado al control garantizado de la calidad de materiales, de componentes y de sistemas estructurales, así como a la evaluación, diagnóstico y arbitraje en problemas de patología de las estructuras.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-estructuras-antisismicas.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Estructuras Antisísmicas,control garantizado,calidad de materiales,componentes,sistemas estructurales' />  
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Estructuras Antisísmicas' />
    <meta property='og:description' content='El Laboratorio de Estructuras Antisísmicas cuenta con más de 30 años dedicado al control garantizado de la calidad de materiales, de componentes y de sistemas estructurales, así como a la evaluación, diagnóstico y arbitraje en problemas de patología de las estructuras.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-estructuras-antisismicas.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Estructuras Antisísmicas</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs">
                    <h1 class="visible-xs-block">Laboratorio de Estructuras Antisísmicas</h1>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <p>El Laboratorio de Estructuras Antisísmicas cuenta con más de 30 años dedicado al control garantizado de la calidad de materiales, de componentes y de sistemas estructurales, así como a la evaluación, diagnóstico y arbitraje en problemas de patología de las estructuras.</p>
            <p>Este laboratorio se especializa en ensayos estáticos y dinámicos a escala natural o reducida para la construcción y el traslado de muestras, el montaje de dispositivos y la aplicación de carga, medición, adquisición y procesamiento de datos.</p>
            <p>Este laboratorio cuenta con 4 tipos de ensayos acreditados por INACAL según NTP-ISO/IEC 17025:2006.</p>
            <ul>
                <li>Compresión axial en probetas cilíndricas (NTP 339.034 2015)</li>
                <li>Flexotracción cargado a los tercios de luz (ASTM C78 / C78M – 18)</li>
                <li>Obtención de núcleos y vigas de concreto (NTP 339.059: 2017)</li>
                <li>Resistencia al tránsito (NTP 339.111 : 1997)</li>
            </ul>
            <br>
            <h3>Este laboratorio puede realizar:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li>Agregados para concreto y mortero.</li>
                        <li>Características y comportamiento de la albañilería (arcilla, concreto, sílico calcáreo).</li>
                        <li>Características y comportamiento del concreto.</li>
                        <li>Características y comportamiento de la madera.</li>
                    </ul>  
                </div>

                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li>Ensayos dinámicos de simulación sísmica o seudo dinámicos de carga lateral cíclica en especímenes a escala natural.</li>
                        <li>Ensayos mecánicos en tubos de PVC, geotextiles, postes de concreto, tapas de buzón, entre otros materiales y elementos.</li>
                        <li>Verificación de equipos de aplicación de carga (prensas, torquímetros, dinamómetros, etc.) y calibración de anillos de carga.</li>
                    </ul>       
                </div>   
            </div> 
        </div> 
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                      <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Mg. Daniel Torrealva Dávila</strong><br>
                            Jefe del Laboratorio<br>
                            Departamento de Ingeniería - Sección de Ingeniería Civil
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 4640
                        </dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd> <a href="mailto:ledi@pucp.pe">ledi@pucp.pe</a></dd>                  
                      </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                     <!-- Indicators -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">

                        <a href="#modal_1" class="openform"><img src="img/estructuras/01.jpg" alt="innovapucp laboratorio estructuras 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/estructuras/01.jpg" alt="innovapucp laboratorio estructuras 01" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                    </div>
                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/estructuras/02.jpg" alt="innovapucp laboratorio estructuras 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/estructuras/02.jpg" alt="innovapucp laboratorio estructuras 02" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>
                    </div>

                    <div class="item">

                        <a href="#modal_3" class="openform"><img src="img/estructuras/03.jpg" alt="innovapucp laboratorio estructuras 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/estructuras/03.jpg" alt="innovapucp laboratorio estructuras 03" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                    </div>

                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/estructuras/04.jpg" alt="innovapucp laboratorio estructuras 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/estructuras/04.jpg" alt="innovapucp laboratorio estructuras 04" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_5" class="openform"><img src="img/estructuras/05.jpg" alt="innovapucp laboratorio estructuras 05" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/estructuras/05.jpg" alt="innovapucp laboratorio estructuras 05" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_6" class="openform"><img src="img/estructuras/06.jpg" alt="innovapucp laboratorio estructuras 06" /></a>
                        <div id="modal_6" class="form">
                            <img class="img-responsive" src="img/estructuras/06.jpg" alt="innovapucp laboratorio estructuras 06" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>
                    </div>

                     <div class="item">
                        <a href="#modal_7" class="openform"><img src="img/estructuras/07.jpg" alt="innovapucp laboratorio estructuras 07" /></a>
                        <div id="modal_7" class="form">
                            <img class="img-responsive" src="img/estructuras/07.jpg" alt="innovapucp laboratorio estructuras 07" />
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Estructuras Antisísmicas</p>
                        </div>
                    </div>
                </div>

                <ol class="carousel-indicators">
                      <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="6"></li>                                 
                </ol>
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="flecha-izquierda" />
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <img src="img/right.png" alt="flecha-derecha" />
                </a>
            </div>
        </div> 
    </div>
    
    <?php include 'include/otros_laboratorios.php';?>   
    <?php include 'include/footer.php';?>
    <script src="<?php echo $host; ?>js/easyResponsiveTabs.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            //Vertical Tab
            $('#acordeon-laboratorio').easyResponsiveTabs({
                type: 'accordion', //Types: default, vertical, accordion
                width: 'auto', //auto or any width like 600px
                fit: true, // 100% fit in a container
                closed: 'accordion', // Start closed if in accordion view
                tabidentify: 'hor_1', // The tab groups identifier

                activetab_bg: '#00adef', // border color for active tabs heads in this group
                inactive_bg: '#fff',
                active_border_color: '#275b6b',
                active_content_border_color: 'red',
                activate: function (event) { // Callback function if tab is switched
                    var $tab = $(this);
                    var $info = $('#nested-tabInfo2');
                    var $name = $('span', $info);
                    $name.text($tab.text());

                    $info.show();
                }
            });
        });
    </script>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
      <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
      <!-- Add mousewheel plugin (this is optional) -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>
      <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
      </script>    

</body>
</html>
