<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio de Manufactura</title> 
    <meta name='title' content='INNOVAPUCP | Laboratorio de Manufactura' />  
    <meta name='description' content='El Laboratorio de Manufactura brinda servicios al sector industrial, mediante la fabricación de componentes y equipos de alta calidad y precisión. Ofrece asesoría en diseño y fabricación, relacionados a proyectos de investigación y creación de prototipos de máquinas.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-manufacturas.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Manufactura, servicios al sector industrial,equipos de alta calidad y precisión,fabricación de componentes,fabricación de equipos,equipos de alta calidad' />  
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Manufactura' />
    <meta property='og:description' content='El Laboratorio de Manufactura brinda servicios al sector industrial, mediante la fabricación de componentes y equipos de alta calidad y precisión. Ofrece asesoría en diseño y fabricación, relacionados a proyectos de investigación y creación de prototipos de máquinas.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-manufacturas.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Manufactura</div>
        </div>
    </div>
    
    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 titulo-xs"><h1 class="visible-xs-block">Laboratorio de Manufactura</h1></div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="text-center">El Laboratorio de Manufactura cuenta con un staff de docentes investigadores de gran experiencia en la fabricación de componentes y equipos de alta calidad y precisión. Asimismo, ofrece asesoría en diseño, creación y fabricación de prototipos de máquinas relacionados a proyectos de investigación.</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <h3>Los principales servicios del laboratorio son:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li>Desarrollo de proyectos de diseño y fabricación de máquinas y componentes de máquinas.</li>
                        <li>Asesoría técnica en ingeniería de producción.</li>
                        <li>Mecanizado en general con máquinas de Control Numérico Computarizado (CNC) y convencionales.</li>
                        <li>Fabricación de estructuras y componentes por distintos procesos de soldadura.</li>
                        <li>Recuperación mediante soldadura de componentes mecánicos.</li>
                    </ul> 
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li>Fabricación de componentes en chapa metálica y por soldadura por puntos.</li>
                        <li>Fabricación de componentes de aluminio por fundición.</li>
                        <li>Fabricación de probetas de diversos materiales para ensayos mecánicos.</li>
                        <li>Mediciones dimensionales y de rugosidad superficial.</li>
                        <li>Desarrollo e implementación de ensayos para la evaluación de equipos industriales.</li>
                     </ul>        
                </div>   
            </div>   
        </div> 
    </div>
    
    <div class="container padding_section">    
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                      <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Ing. Jorge Fernández Fernández</strong><br>
                            Jefe del Laboratorio<br>
                            Departamento de Ingeniería - Sección de Ingeniería Mecánica
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 4855 | 4835</dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd><a href="mailto:labman@pucp.edu.pe">labman@pucp.edu.pe</a> / <a href="mailto:jorge.fernandezf@pucp.edu.pe">jorge.fernandezf@pucp.edu.pe </a></dd>                  
                      </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/manufactura/01.jpg" alt="innovapucp laboratorio manufactura 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/manufactura/01.jpg" alt="innovapucp laboratorio manufactura 01" />
                            <p>Laboratorio de Manufactura</p>
                        </div>
                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/manufactura/02.jpg" alt="innovapucp laboratorio manufactura 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/manufactura/02.jpg" alt="innovapucp laboratorio manufactura 02" />
                            <p>Laboratorio de Manufactura</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_3" class="openform"><img src="img/manufactura/03.jpg" alt="innovapucp laboratorio manufactura 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/manufactura/03.jpg" alt="innovapucp laboratorio manufactura 03" />
                            <p>Laboratorio de Manufactura</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/manufactura/04.jpg" alt="innovapucp laboratorio manufactura 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/manufactura/04.jpg" alt="innovapucp laboratorio manufactura 04" />
                            <p>Laboratorio de Manufactura</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_5" class="openform"><img src="img/manufactura/05.jpg" alt="innovapucp laboratorio manufactura 05" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/manufactura/05.jpg" alt="innovapucp laboratorio manufactura 05" />
                            <p>Laboratorio de Manufactura</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_6" class="openform"><img src="img/manufactura/06.jpg" alt="innovapucp laboratorio manufactura 06" /></a>
                        <div id="modal_6" class="form">
                            <img class="img-responsive" src="img/manufactura/06.jpg" alt="innovapucp laboratorio manufactura 06" />
                            <p>Laboratorio de Manufactura</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura</p>
                        </div>
                    </div>
                     <div class="item">

                        <a href="#modal_7" class="openform"><img src="img/manufactura/07.jpg" alt="innovapucp laboratorio manufactura 07" /></a>
                        <div id="modal_7" class="form">
                            <img class="img-responsive" src="img/manufactura/07.jpg" alt="innovapucp laboratorio manufactura 07" />
                            <p>Laboratorio de Manufactura Centro de Mecanizado</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura Centro de Mecanizado</p>
                        </div>

                    </div>
                     <div class="item">

                        <a href="#modal_8" class="openform"><img src="img/manufactura/08.jpg" alt="innovapucp laboratorio manufactura 08" /></a>
                        <div id="modal_8" class="form">
                            <img class="img-responsive" src="img/manufactura/08.jpg" alt="innovapucp laboratorio manufactura 08" />
                            <p>Laboratorio de Manufactura Torno Horizontal</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura Torno Horizontal</p>
                        </div>

                    </div>
                     <div class="item">

                        <a href="#modal_9" class="openform"><img src="img/manufactura/09.jpg" alt="innovapucp laboratorio manufactura 09" /></a>
                        <div id="modal_9" class="form">
                            <img class="img-responsive" src="img/manufactura/09.jpg" alt="innovapucp laboratorio manufactura 09" />
                            <p>Laboratorio de Manufactura Torno Horizontal</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura Torno Horizontal</p>
                        </div>

                    </div>
                     <div class="item">

                        <a href="#modal_10" class="openform"><img src="img/manufactura/10.jpg" alt="innovapucp laboratorio manufactura 10" /></a>
                        <div id="modal_10" class="form">
                            <img class="img-responsive" src="img/manufactura/10.jpg" alt="innovapucp laboratorio manufactura 10" />
                            <p>Laboratorio de Manufactura Fresadora Universal</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Manufactura Fresadora Universal</p>
                        </div>
                    </div>
                </div>

                <ol class="carousel-indicators">
                  <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="6"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="7"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="8"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="9"></li>
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">

                    <img src="img/left.png" alt="">
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">

                    <img src="img/right.png" alt="">
                </a>
            </div>
        </div>
    </div>

    <?php include 'include/otros_laboratorios.php';?>   
    <?php include 'include/footer.php';?>

    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
      <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
      <!-- Add mousewheel plugin (this is optional) -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

      <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
      </script>
</body>
</html>
