<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</title> 
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada' />  
    <meta name='description' content='El laboratorio forma parte del Instituto de Ciencias Ómicas y Biotecnología Aplicada (ICOBA PUCP) que se dedica a la investigación interdisciplinaria para el desarrollo de metodologías y tecnologías para el análisis de materiales de origen biológico.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-del-instituto-de-ciencias-omicas-y-biotecnologia-aplicada.php' />
    <meta name='keywords' content='INNOVAPUCP,Instituto de Ciencias Ómicas y Biotecnología Aplicada,desarrollo de metodologías,análisis de materiales, biológico.' />  
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada' />
    <meta property='og:description' content='El laboratorio forma parte del Instituto de Ciencias Ómicas y Biotecnología Aplicada (ICOBA PUCP) que se dedica a la investigación interdisciplinaria para el desarrollo de metodologías y tecnologías para el análisis de materiales de origen biológico.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-del-instituto-de-ciencias-omicas-y-biotecnologia-aplicada.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs">
                    <h1 class="visible-xs-block">Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">                  
                    <h3 class="text-center">El Instituto de Ciencias Ómicas y Biotecnología Aplicada (ICOBA PUCP) se dedica a la investigación interdisciplinaria para el desarrollo de metodologías y tecnologías para el análisis de materiales de origen biológico a cargo de investigadores especializados.</h3>                   
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <h3>Este laboratorio puede realizar:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li>Control de calidad: Pureza de los insumos, de los productos, de los solventes y otros.</li>
                        <li>Formulación, ejecución y gestión de proyectos de investigación, adaptación y desarrollo de nuevas soluciones tecnológicas y diseño de productos de base biotecnológica.</li>
                        <li>Preparación de Informes Técnicos sobre metodologías bioanalíticas. </li>
                    </ul>  
                </div>

                <div class="col-sm-12 col-md-6 container-border">
                    <ul>                        
                        <li>Actividades de articulación: Participación en mesas de elaboración de normas técnicas, comunicación con centros análogos del país o del exterior, para el intercambio de experiencias y conocimientos.</li>
                        <li>Transferencia de conocimiento: Acompañamiento analítico y asistencia técnica para la optimización de la producción de compuestos de interés comercial de origen biológico. Cursos sobre tecnologías analíticas para las empresas y los sectores productivos.</li>
                        <li>Determinar la presencia y/o cantidad de compuestos químicos en mezclas o matrices diversas.</li>
                    </ul>       
                </div>   
            </div> 
        </div> 
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                      <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Dr. Alfredo J. Ibáñez</strong><br>
                            Jefe del Laboratorio
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 2506
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd> <a href="mailto:icoba@pucp.edu.pe">icoba@pucp.edu.pe </a></dd>
                      </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/ciencias-omicas-y-biotecnologia/01.jpg" alt="innovapucp laboratorio" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/ciencias-omicas-y-biotecnologia/01.jpg" alt="innovapucp laboratorio" />
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                        <div class="carousel-caption">    
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/ciencias-omicas-y-biotecnologia/02.jpg" alt="innovapucp laboratorio" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/ciencias-omicas-y-biotecnologia/02.jpg" alt="innovapucp laboratorio" />
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_3" class="openform"><img src="img/ciencias-omicas-y-biotecnologia/03.jpg" alt="innovapucp laboratorio" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/ciencias-omicas-y-biotecnologia/03.jpg" alt="innovapucp laboratorio" />
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/ciencias-omicas-y-biotecnologia/04.jpg" alt="innovapucp laboratorio" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/ciencias-omicas-y-biotecnologia/04.jpg" alt="innovapucp laboratorio" />
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_5" class="openform"><img src="img/ciencias-omicas-y-biotecnologia/05.jpg" alt="innovapucp laboratorio" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/ciencias-omicas-y-biotecnologia/05.jpg" alt="innovapucp laboratorio" />
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_6" class="openform"><img src="img/ciencias-omicas-y-biotecnologia/06.jpg" alt="innovapucp laboratorio" /></a>
                        <div id="modal_6" class="form">
                            <img class="img-responsive" src="img/ciencias-omicas-y-biotecnologia/06.jpg" alt="innovapucp laboratorio" />
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio del Instituto de Ciencias Ómicas y Biotecnología Aplicada</p>
                        </div>
                    </div>
                </div>

                <ol class="carousel-indicators">
                  <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>                
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">

                    <img src="img/left.png" alt="">
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">

                    <img src="img/right.png" alt="">
                </a>
            </div>
        </div>
    </div>
    
    <?php include 'include/otros_laboratorios.php';?>   
    <?php include 'include/footer.php';?>
    <script src="<?php echo $host; ?>js/easyResponsiveTabs.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            //Vertical Tab
            $('#acordeon-laboratorio').easyResponsiveTabs({
                type: 'accordion', //Types: default, vertical, accordion
                width: 'auto', //auto or any width like 600px
                fit: true, // 100% fit in a container
                closed: 'accordion', // Start closed if in accordion view
                tabidentify: 'hor_1', // The tab groups identifier

                activetab_bg: '#00adef', // border color for active tabs heads in this group
                inactive_bg: '#fff',
                active_border_color: '#275b6b',
                active_content_border_color: 'red',
                activate: function (event) { // Callback function if tab is switched
                    var $tab = $(this);
                    var $info = $('#nested-tabInfo2');
                    var $name = $('span', $info);
                    $name.text($tab.text());

                    $info.show();
                }
            });
        });
    </script>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
      <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
      <!-- Add mousewheel plugin (this is optional) -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>
      <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
      </script>    

</body>
</html>
