<?php 
  include 'include/head.php';

?>
    <title>INNOVAPUCP | Nosotros</title>
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Nosotros' />
    <meta name='description' content='INNOVAPUCP es el Centro de Consultoría y Servicios Integrados de la Pontificia Universidad Católica del Perú [PUCP] con más de 20 años de experiencia en el mercado, caracterizado por crear constantemente valor en las organizaciones y respaldado por un gran equipo de profesionales, una infraestructura tecnológica de última generación y una red de modernos laboratorios.'
    />
    <meta name='url' content='<?php echo $host; ?>cultura-organizacional.php' />
    <meta name='keywords' content='INNOVAPUCP, Nosotros, equipo de profesionales, Centro de Consultoría,Pontificia Universidad Católica del Perú' />
    <!-- OpenGraph Meta Tags -->
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Nosotros' />
    <meta property='og:description' content='INNOVAPUCP es el Centro de Consultoría y Servicios Integrados de la Pontificia Universidad Católica del Perú [PUCP] con más de 20 años de experiencia en el mercado, caracterizado por crear constantemente valor en las organizaciones y respaldado por un gran equipo de profesionales, una infraestructura tecnológica de última generación y una red de modernos laboratorios.'
    />
    <meta property='og:url' content='<?php echo $host; ?>cultura-organizacional.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes.jpg' />
</head>

<body id="quienes-somos">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="6" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="texto-menu">
        <div class="container">Nosotros</div>
    </div>

    <div class="container padding_section introduccion-quienes-somos">
        <div class="row">
            <div class="col-xs-12 separador-top titulo-xs">
                <h1 class="visible-xs-block">Nosotros</h1>
            </div>
        </div>
        <div class="row">
            <div class=" col-sm-12">
                <h2>Somos el Centro de Consultoría y Servicios Integrados de <br class="hidden-xs">la Pontificia Universidad Católica del Perú</h2>
            </div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="quienes-somo-objetivos container-ventajas">
            <div class="row-table">
                <div class="col-sm-6 container-border">
                    <p>Brindamos soluciones con elevados estándares de calidad mediante la transferencia de conocimiento y la proyección tecnológica, social y cultural. Trabajamos a la medida de las necesidades de empresas, entidades públicas, sociedad civil y organismos de cooperación internacional.</p>
                </div>
                <div class="col-sm-6  container-border">
                    <p>Contamos con más de 25 años de experiencia, trabajamos con equipos de docentes consultores PUCP multi e interdisciplinarios, laboratorios de última generación, áreas académicas, y el respaldo y excelencia de nuestra universidad.</p>
                </div>
            </div>
        </div>
    </div>

    <br>
    <div class="sec-bg-txt-hover" style="background-image: url(img/quienes-somos/bg-compromiso.jpg);">
        <div class="container padding_section text-center">
            <div class="row padding_section">
                <div class="col-lg-10 col-lg-offset-1">
                    <h2 class="bg-txt-hover__h">COMPROMISO</h2>
                    <p class="bg-txt-hover__p">Nuestro principal compromiso es ofrecer soluciones de alto valor agregado a las organizaciones públicas, privadas y cooperación internacional, para de esta manera contribuir con el desarrollo de la sociedad. A través de nuestras soluciones buscamos fortalecer la relación entre la universidad, empresa, Estado y sociedad.</p>
                </div>
            </div>
        </div>
    </div>

    <br>
    <div id="principios">
        <div class="container padding_section quienes-somo-objetivos">
            <div class="row">
                <div class="col-sm-12 text-center">
                    <h2>PRINCIPIOS</h2>
                </div>
            </div>
            <div class="row-table">
                <div class="col-sm-4 container-border">
                    <img src="img/principios/cliente-innovapucp.png" class="center-block" alt="Enfoque en el bienestar de nuestros clientes"><br>
                    <h3 class="text-center">Desarrollo del sector público y privado, y del bienestar de la sociedad</h3>
                    <p>Agregar valor a la toma de decisiones de nuestros clientes y contribuir con el crecimiento de su organización a través de vínculos sostenibles, soluciones integradas, relevantes, oportunas y confiables.</p>
                    <p>Contribuir de manera directa con el desarrollo y bienestar de la sociedad a través de la transferencia de conocimiento y proyección tecnológica, social y cultural.</p>
                </div>
                <div class="col-sm-4  container-border">
                    <img src="img/principios/innovacion-innovapucp.png" class="center-block" alt="Innovación y ética como motores de la excelencia"><br>
                    <h3 class="text-center">Cultura de la innovación <br>y ética</h3>
                    <p>Implementar soluciones que permitan afrontar retos de desarrollo y contribuir a resolver los desafíos de la innovación. Soluciones respaldadas por la experiencia de nuestros docentes consultores, la infraestructura, la tecnología y los principios éticos de la PUCP.</p>
                </div>
                <div class="col-sm-4  container-border">
                    <img src="img/principios/pieza-innovapucp.png" class="center-block" alt="Ser pieza esencial en el equipo"><br>
                    <h3 class="text-center">Trabajo colaborativo <br>e interdisciplinario</h3>
                    <p>Poner a disposición de las empresas el conocimiento y experiencia de nuestros docentes consultores,  con capacidad para diseñar y ejecutar propuestas integrales, a través del monitoreo constante y participativo.</p>
                </div>
            </div>
        </div>
    </div>
    <?php include 'include/footer.php';?>
</body>

</html>
