<!DOCTYPE html>
<html lang="es-pe">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->

<!-- favicon -->
<link rel="shortcut icon" href="img/favicon.png">
<!-- Bootstrap -->
<link rel="stylesheet" href="css/bootstrap.min.css">
<!-- Bootstrap Select -->
<link rel="stylesheet" href="css/bootstrap-select.min.css">
<!-- main css -->
<link rel="stylesheet" href="css/main.css">

<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
<!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

<!-- EN CADA PÁGINA ############################# -->
<title>SEMINARIO INTERNACIONAL UDEP | Admisión UDEP</title>
<!-- Basic HTML Meta Tags -->
<meta name='title' content='SEMINARIO INTERNACIONAL UDEP | Admisión UDEP' />
<meta name='description' content='El espíritu de la Universidad de Piura se centra en brindar formación integral y preparación profesional a sus alumnos, de modo que puedan promover el bien común en la sociedad.' />
<meta name='url' content='http://seminariointernacionaludep.com/' />
<meta name='keywords' content='SEMINARIO INTERNACIONAL UDEP, Seminario Internacional de Reputación Educativa' />
<!-- OpenGraph Meta Tags -->
<meta property="og:type" content='website' />
<meta property='og:title' content='SEMINARIO INTERNACIONAL UDEP | Admisión UDEP' />
<meta property='og:description' content='El espíritu de la Universidad de Piura se centra en brindar formación integral y preparación profesional a sus alumnos, de modo que puedan promover el bien común en la sociedad.' />
<meta property='og:url' content='http://seminariointernacionaludep.com/' />
<meta property='og:image' content='http://seminariointernacionaludep.com/img/landing-compartir.jpg' />
<!-- ############################################ -->
</head>
<body>

<script>
    (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
   (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
   m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
   })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
   ga('create', 'UA-55699707-1', 'auto');
   ga('send', 'pageview');
</script>

<header>
	<!-- <img class="img-responsive" src="http://placehold.it/1280x410" alt="..."> -->
      <div id="fondo" class="">
            <div class="container relative">
                  <div class="row center-block">      
                        <img class="img-responsive titulo" src="img/titulo.svg" alt="...">      
                  </div>      
      </div>
</header>

<div id="seccion-uno">
      <div class="faja">
            <div class="container relative">
                  <div class="row">
                        <div class="col-xs-4 col-sm-4">
                              <img class="img-responsive"  src="img/logo-01.svg" alt="...">
                        </div>
                        <div class="col-xs-4 col-sm-4">
                              <img class="img-responsive center-block"  src="img/logo-02.svg" alt="...">
                        </div>
                        <div class="col-xs-4 col-sm-4">
                               <img class="img-responsive center-block pull-right"   src="img/logo-03.png" alt="...">
                        </div>
                  </div>
            </div>
      </div>
	<div class="container">
		<div class="row">
			<div class="col-sm-12 context">
				<p class="titulo1">MIÉRCOLES 30 DE MAYO</p>
                        <p class="titulo2">8:00 A.M. a 5:30 P.M.</p>
                        <p class="titulo3">Salón San Martín del Hotel J.W. Marriott Lima</p>

                        <hr class="hr-custom">

                        <p class="text-justify">El espíritu de la Universidad de Piura se centra en brindar formación integral y preparación profesional a sus alumnos, de modo que puedan promover el bien común en la sociedad.</p>

                        <p class="text-justify">Este mismo principio lo compartimos con los colegios, que son el primer paso para brindar una educación basada en valores. Bajo esta visión, de formar profesionales completos y con el ánimo de impulsar y divulgar temas relevantes que contribuyan a este objetivo es que creamos el <strong class="bold"> Seminario Internacional de Reputación Educativa</strong> en su segunda edición que nos ayudará a absolver algunas dudas no resueltas el 2017.</p>
			</div>
			
		</div>
	</div>
</div>

<div id="seccion-dos">
	<div class="container">
		<div class="row row-table">
			<div class="col-sm-4">
				<div class="txt-confirma">
					Confirma tu
					<br>asistencia:
				</div>
				<p>Ingrese los datos del Director y un invitado para confirmar tu asistencia:</p>
				<p><strong><small>* En caso requerir una vacante adicional por favor contactar con su Gestora de Canal. Vacantes limitadas.</small></strong></p>
			</div>
			<div class="col-sm-8">
				<form method="post" id="formulario" action="">
					<div class="row">
						<div class="col-sm-6 col-padding">
							<div class="txt-label">Datos Personales:</div>
							<div class="form-group">
								<input type="text" class="form-control" placeholder="Nombres y Apellidos" name="asistente">
							</div>

							<div class="form-group">
								<input type="text" class="form-control" placeholder="Correo" name="correo">
							</div>

							<!--<div class="txt-label"></div>-->
							<div class="form-group">
                                                <select class="form-control selectpicker" name="cargo" title="Selecciona tu Cargo">
                                                      <option value="Director(a)">Director(a)</option>
                                                      <option value="Orientador(a) Vocacional">Orientador(a) Vocacional</option>
                                                      <option value="Psicologo(a)">Psicólogo(a)</option>
                                                      <option value="Docente">Docente</option>
								</select>
							</div>
                                    </div>
                                    

						<div class="col-sm-6 col-padding">
                                          <div class="txt-label">Colegio:</div>
                                          <div class="form-group">
                                                <!--<input type="text" class="form-control" placeholder="Nombre asistente" name="invitado01_nombre">-->
                                                <select class="form-control selectpicker" name="colegio" title="Selecciona...">
                                                      <option value="Abraham Lincoln">Abraham Lincoln</option>
                                                      <option value="Alexander Von Humboldt">Alexander Von Humboldt</option>
                                                      <option value="Alpamayo">Alpamayo</option>
                                                      <option value="Altair">Altair</option>
                                                      <option value="América del Callao">América del Callao</option>
                                                      <option value="Antares">Antares</option>
                                                      <option value="Antonio Raimondi">Antonio Raimondi</option>
                                                      <option value="Augusto Weberbauer">Augusto Weberbauer</option>
                                                      <option value="Cambridge College">Cambridge College</option>
                                                      <option value="Casuarinas College">Casuarinas College</option>
                                                      <option value="Champagnat">Champagnat</option>
                                                      <option value="Claretiano">Claretiano</option>
                                                      <option value="Cooperativo la Unión">Cooperativo la Unión</option>
                                                      <option value="Cristo salvador">Cristo salvador</option>
                                                      <option value="De la Inmaculada">De la Inmaculada</option>                                                
                                                      <option value="Euroamericano">Euroamericano</option>
                                                      <option value="Franco Peruano">Franco Peruano</option>
                                                      <option value="Franklin D. Roosevelt">Franklin D. Roosevelt</option>
                                                      <option value="Hans Christian Andersen">Hans Christian Andersen</option>
                                                      <option value="Hiram Bingham">Hiram Bingham</option>
                                                      <option value="Humtec">Humtec</option>
                                                      <option value="Isabel Flores de Oliva">Isabel Flores de Oliva</option>
                                                      <option value="La Inmaculada Concepción">La Inmaculada Concepción</option>
                                                      <option value="Leon Pinelo">León Pinelo</option>
                                                      <option value="Leonardo Da Vinci">Leonardo Da Vinci</option>
                                                      <option value="Liceo Naval Almarirante Guise">Liceo Naval Almarirante Guise</option>
                                                      <option value="Los Alamos">Los Álamos</option>
                                                      <option value="Magister">Magister</option>
                                                      <option value="María Alvarado">María Alvarado</option>
                                                       <option value="María de los Ángeles">María de los Ángeles</option>
                                                      <option value="María Molinari">María Molinari</option>
                                                      <option value="María Reina Marianistas">María Reina Marianistas</option>
                                                      <option value="Markham College">Markham College</option>
                                                      <option value="Mater Admirabilis">Mater Admirabilis</option>
                                                      <option value="Mater Purissima">Mater Purissima</option>
                                                      <option value="Miravalles">Miravalles</option>
                                                      <option value="Montealto">Montealto</option> 
                                                      <option value="Newton College">Newton College</option>                                                
                                                      <option value="Nivel A">Nivel A</option>                                                      
                                                      <option value="Nuestra Señora del Carmen">Nuestra Señora del Carmen (Carmelitas)</option>
                                                      <option value="Peruano Británico">Peruano Británico</option>
                                                      <option value="Peruano Chino Juan XXIII">Peruano Chino Juan XXIII</option>
                                                      <option value="Pestalozzi">Pestalozzi</option>
                                                      <option value="Regina Pacis">Regina Pacis</option>
                                                      <option value="Reina de los Ángeles">Reina de los Ángeles</option>
                                                      <option value="Reina del Mundo">Reina del Mundo</option>
                                                      <option value="S.C. Belen">S.C. Belen</option>
                                                      <option value="S.C. Recoleta">S.C. Recoleta</option>
                                                      <option value="S.C. Sophianum">S.C. Sophianum</option>
                                                      <option value="Salcantay">Salcantay</option>
                                                      <option value="San Agustín">San Agustín</option>
                                                      <option value="San Antonio de Padua">San Antonio de Padua</option>
                                                      <option value="San Charbel">San Charbel</option>
                                                      <option value="San Charbel">San Ignacio de Recalde</option>
                                                      <option value="San José de Cluny - Barranco">San José de Cluny - Barranco</option>
                                                      <option value="San José de Cluny - Surquillo">San José de Cluny - Surquillo</option> 
                                                      <option value="San José de Monterrico">San José de Monterrico</option>
                                                      <option value="San Pedro">San Pedro</option>
                                                      <option value="San Silvestre School">San Silvestre School</option>
                                                      <option value="Santa Margarita">Santa Margarita</option>
                                                      <option value="Santa María Marianistas">Santa María Marianistas</option>
                                                      <option value="Santa Rita de Casia">Santa Rita de Casia</option>
                                                      <option value="Santa Teresita">Santa Teresita</option>
                                                      <option value="Santa Úrsula">Santa Úrsula</option>
                                                      <option value="Santísimo Nombre de Jesús">Santísimo Nombre de Jesús</option>
                                                      <option value="ST. George´s College">ST. George´s College</option>
                                                      <option value="Trener">Trener</option>
                                                      <option value="Villa Alarife">Villa Alarife</option>
                                                      <option value="Villa Caritas">Villa Caritas</option>
                                                      <option value="Villa María la Planicie">Villa María la Planicie</option>
                                                </select>
                                          </div>
                                          <br>
                                          <!--<a class="btn-enviar pull-right" href="#">ENVIAR</a>-->
                                          <input type="button" id="btn_enviar" name="login" class="btn-enviar pull-right" value="ENVIAR" style="cursor:pointer; ">
                                          <div id="respuesta"  style="float:left; clear:both; font-size:11px; font-weight:normal; text-align:center; color:#FC070B; border:none"></div>
                                    </div>
                                          <!--<div class="txt-label">Selecciona el 1° Taller al que asistirás:</div>
                                          <div class="form-group">
                                                <select class="form-control selectpicker" name="taller1" title="Selecciona...">
                                                      <option value="Taller I: Estrategias de generación de contenido para la web y las redes sociales">Taller I: Estrategias de generación de contenido para la web y las redes sociales</option>
                                                      <option value="Taller II: El relato institucional">Taller II: El relato institucional</option>
                                                </select>      
                                          </div>

                                          
                                          <div class="txt-label">Selecciona el 2° Taller al que asistirás:</div>
                                          <div class="form-group">
                                                <select class="form-control selectpicker" name="taller2" title="Selecciona...">
                                                      <option value="Taller III: Crisis: resolución de casos concretos">Taller III: Crisis: resolución de casos concretos</option>
                                                      <option value="Taller IV: Derecho y Comunicación">Taller IV: Derecho y Comunicación</option>
                                                </select>      
                                          </div>-->						
						</div>
					</div>		
				</form>
			</div>
		</div>
	</div>
</div>

<div id="seccion-tres">
	<div id="accordion">
		<div id="panel-1" class="panel">
			<a class="titulo-accordion container expand" data-toggle="collapse" data-parent="#accordion" href="#collapse_1">
				Programa: miércoles 30 de mayo de 2018 (Lima)	<span class="pull-right" style="color:#fff">▼</span>
			</a>
			<div id="collapse_1" class="collapse container">
				<div class="panel-cuerpo">
					<table class="table">
						<thead>
							<tr>
								<th>HORA:</th>
								<th>SESIÓN</th>
                                                <th>EXPOSITORES</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>8:00</td>
								<td>Recepción, entrega de documentos.<br>Coffee break de bienvenida</td>
								<td></td>
							</tr>
							<tr>
								<td>8:30 - 9:00</td>
								<td>Palabras de bienvenida</td>
                                                <td>Dra. Sandra Orejuela</td>
							</tr>
                                          <tr>
                                                <td>9:00 - 9:40</td>
                                                <td>Sesión plenaria I: Un entorno que cambia.</td>
                                                <td>Dr. Fernando Huamán - Universidad de Piura <br>Dr. Yago de la Cierva - Universidad de Navarra</td>
                                          </tr>
                                        <tr>
                                            <td>9:40 - 10:20</td>
                                            <td>Sesión plenaria II: Gestión institucional del cambio.</td>
                                             <td>Dra. Begoña Echevarne - Universidad de Navarra</td>
                                        </tr>
							<tr>
								<td>10:20 - 10:50</td>
								<td>Presentación de Empantallados</td>
                                                <td></td>
							</tr>
							<tr>
								<td>10:50 - 11:10</td>
								<td>Coffee Break</td>
                                                <td></td>
							</tr>
                                          <tr>
                                                <td>11:10 - 12:20</td>
                                                <td> Taller I: Estrategias de generación de contenido para la web y las redes sociales.</td>
                                                <td>Dr. Francisco Arbaiza - Universidad de Piura</td>
                                          </tr>
							<tr>
								<td>12:20 - 1:30</td>
								<td>Taller 2: El relato institucional </td>
								<td>Dra. Begoña Echevarne - Universidad de Navarra</td>
							</tr>
							<tr>
								<td>1:30 - 15:00</td>
								<td>Almuerzo</td>
                                                <td></td>
							</tr>
                                          <tr>
                                                <td>15:00 - 15:50</td>
                                                <td>Sesión plenaria III: Gestión de Crisis</td>
                                                <td>Dr. Yago de la Cierva - Universidad de Navarra</td>
                                          </tr>
                                          <tr>
                                                <td>15:50 - 16:20</td>
                                                <td>Taller 3: Derecho y Comunicación </td>
                                                <td>Dra. Margarita Quiroz - Universidad de Piura</td>
                                          </tr>
                                          <tr>
                                                <td>16:20 - 17:30</td>
                                                <td>Taller 4: Crisis (resolución de casos concretos) </td>
                                                <td>Dr. Yago de la Cierva - Universidad de Navarra</td>
                                          </tr>
						</tbody>
					</table>
                              
                              <br>
                              <small class="color-white ">(*) En el taller 4, a cargo de Yago de la Cierva, se resolverán casos reales. Agradeceremos enviar un email a <a href="mailto:seminario.udep@udep.pe" class="color-white"><u>seminario.udep@udep.pe</u></a> hasta el Viernes 18 de Mayo con los temas o inquietudes que desean que el expositor resuelva (pueden ser casos anónimos si así lo desea).</small>
				</div>
			</div>
		</div>

		<div id="panel-3" class="panel">
			<a class="titulo-accordion container expand" data-toggle="collapse" data-parent="#accordion" href="#collapse_3">
				Expositores del Seminario<span class="pull-right" style="color:#fff">▼</span>
			</a>
			<div id="collapse_3" class="collapse container">
                        <div class="panel-cuerpo">
                              <div class="row">
                                    <div class="col-xs-12 col-sm-4 col-md-4">
                                        <div class="container-autoridades">
                                            <div class="autoridades">                                   
                                                <!-- <img class="img-responsive" src="http://placehold.it/360x400" alt="..."> -->
                                                <img class="center-block img-responsive" src="img/francisco-arbaiza.jpg">
                                                <div class="over">
                                                    <div class="over-padre">
                                                        <div class="over-celda">
                                                            Profesor universitario e investigador en el ámbito de las nuevas tendencias del marketing contemporáneo. PhD en Comunicaciones de Marketing en la Universidad de Navarra (España) y Licenciado en Comunicación por la Universidad de Piura. Actualmente jefe del Área Académica de Comunicaciones de Marketing de la Facultad de Comunicación. 

                                                            Autor de dos recientes libros que recogen gran parte de su investigación en los últimos años: "Marketing experiencial: el marketing a través de las experiencias del consumidor" (2017) y "Aproximación a un marketing postmoderno: la influencia del postmodernismo en las comunicaciones de marketing, el consumidor y la construcción de marcas (2016).

                                                            Sus actuales proyectos de investigación incluyen: El marketing de contenidos, el storytelling publicitario y su trascendencia en el contexto comercial y social; y las marcas y su diálogo con el consumidor en los nuevos escenarios digitales.
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="nombre">Ph.D. Francisco Arbaiza</div>
                                            <div class="cargo"></div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-xs-12 col-sm-4 col-md-4">
                                          <div class="container-autoridades">
                                                <div class="autoridades">
                                                    <img class="center-block img-responsive" src="img/yago-de-la-cierva.jpg">
                                                    <div class="over">
                                                      <div class="over-padre">
                                                            <div class="over-celda">
                                                                  Licenciado en Derecho, Universidad de Santiago de Compostela. Doctor en Filosofía por la Universidad de Navarra. 
                                                                  Se especializó en Comunicación Institucional en la Pont. Univ. de la Santa Cruz, Roma, y ha cursado el Program for Management Development (PMD), IESE.

                                                                  Es colaborador científico del IESE Business School, Universidad de Navarra, encargado de la asignatura “Corporate Communications”, MBA del IESE (2013 – )
                                                                  <!--Especialista en reputación corporativa y comunicaciones integrales. Profesor de “Comunicación preventiva y gestión de crisis”, Facultad de Comunicación Institucional de la Iglesia, Pontificia Universidad de la Santa Cruz, Roma (1999 – )-->
                                                                  Profesor de las materias “Organización de eventos” y “Plan de comunicación” del Máster de Protocolo, organización de eventos y comunicación”, Universidad Rey Juan Carlos (2012).
                                                            </div>
                                                      </div>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="nombre">Ph.D. Yago de la Cierva</div>
                                                <div class="cargo"></div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-4 col-md-4">
                                          <div class="container-autoridades">
                                                <div class="autoridades">
                                                      <img class="center-block img-responsive" src="img/begona_echevarne.jpg">
                                                      <div class="over">
                                                            <div class="over-padre">
                                                                  <div class="over-celda">
                                                                        Licenciada en Artes (BA) y Periodismo en la Universidad de Navarra. 
                                                                        Cuenta con una maestría en gobierno institucional y cultura a través de la misma institución.

                                                                        Desde 2009, es Directora de Comunicación Interna de la Universidad de Navarra y consultora de comunicación establecida. 
                                                                        En 2003, inició y dirigió el departamento de comunicación interna de la Clínica Universidad de Navarra, donde ocupó el cargo de codirectora de comunicaciones Antes de ese cargo, estuvo a cargo durante más de diez años del Departamento de Comunicación de la Facultad de Ingeniería de la Universidad de Navarra (TECNUN) y del centro de investigación técnica, CEIT o Centro de Estudios e Investigaciones Técnicas de Guipúzcoa.

                                                                        También ha participado como profesora asociada de las clases "Comunicación escrita y corporativa" en la Universidad de Navarra. Ha tenido varias conferencias en diversas instituciones educativas y  del sector de la salud, las cuales trataban sobre comunicación interna y externa, imagen y reputación de profesionales en instituciones. También ha sido directora de diseño y composición de la revista "Nuestro Tiempo", además de haber fundado y colaborado en la edición de impresión institucional y sus versiones en línea.
                                                                  </div>
                                                            </div>
                                                      </div>
                                                </div>
                                                <br>
                                                <div class="nombre">Dra. Begoña Echevarne</div>
                                                <div class="cargo"></div>
                                          </div>
                                    </div>                                          
                              </div>

                                <div class="row">            
                                    <div class="col-xs-12 col-sm-4 col-md-4">
                                        <div class="container-autoridades">
                                            <div class="autoridades">
                                                <img class="center-block img-responsive" src="img/fernando-huaman.jpg">
                                                <div class="over">
                                                    <div class="over-padre">
                                                        <div class="over-celda">
                                                            Doctor Internacional en Comunicación por la Universidad de Navarra (España). Licenciado en Comunicación, Bachiller en Filosofía y Diplomado en Educación por la Universidad de Piura (Perú). Premio Extraordinario de Doctorado en Comunicación. Investigador en Comunicación y director del Centro de Investigación en Opinión Pública (CIOP) de la Facultad de Comunicación de la Universidad de Piura. Director de Departamento.
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="nombre">Dr. Fernando Huamán</div>
                                            <div class="cargo"></div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-xs-12 col-sm-4 col-md-4">
                                          <div class="container-autoridades">
                                                <div class="autoridades">
                                                    <img class="center-block img-responsive" src="img/margarita-quiroz.jpg">
                                                    <div class="over">
                                                      <div class="over-padre">
                                                            <div class="over-celda">                                                                  
                                                                Abogada por la Universidad de Piura. Bachiller en Historia por la Universidad de Piura. Cuenta con una postgrado en Derecho Civil y Comercial. También es egresada en Maestría en Derecho Laboral de la Universidad San Martín de Porres. Primer puesto en el concurso de admisión en Maestría en Gobernabilidad por el Instituto de Gobierno de la Universidad San Martín de Porres.
                                                            </div>
                                                      </div>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="nombre">Abogada. Margarita María Quiroz</div>
                                                <div class="cargo"></div>
                                          </div>
                                    </div>
                              </div>    
                        </div>
                  </div>

                <div class="row">
                        
                </div>      
            </div>
	</div>
     </div>
  </div>
</div>



<footer>
	<div class="container">
		Universidad de Piura - Todos los derechos reservados 2018
	</div>
</footer>

<?php include "include/disclaimer.php"; ?>

<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<!--<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>-->
<!-- Include all compiled plugins (below), or include individual files as needed -->
<script src="js/bootstrap.min.js"></script>
<!-- Bootstrap Select -->
<script src="js/bootstrap-select.min.js"></script>

<!--Plug-in Initialisation-->
	<script type="text/javascript">
		// $(document).ready(function() {
		// });

		$(function() {
		  $(".expand").on( "click", function() {
		    // $(this).next().slideToggle(200);
		    $expand = $(this).find(">:first-child");
		    
		    if($expand.text() == "▼") {
		      $expand.text("▲");
		    } else {
		      $expand.text("▼");
		    }
		  });
		  
		$("#btn_enviar").click(function(){
			var url = "send.php"; // El script a dónde se realizará la petición.
			$("#respuesta").html("Procesando, espere por favor...");
			$("#btn_enviar").css("display", "none");
			$.ajax({
				type: "POST",
				url: url,
				data: $("#formulario").serialize(), // Adjuntar los campos del formulario enviado.
				success: function(data){
					ncantidad = data.length;
					//alert(ncantidad);
					if ( ncantidad <= "10"){
							$("#respuesta").html("<span style='color:#3C0'>Tus datos han sido guardados correctamente!</span>");
							$(".form-control").val("");
							$("#btn_enviar").css("display", "inline-block");
					}else{
						//$("#respuesta").html("<span style='color:#000'>"+data+"</span>"); // Mostrar la respuestas del script PHP.
						$("#respuesta").html(data);
						$("#btn_enviar").css("display", "inline-block");
					}
				}
			});
			return false; // Evitar ejecutar el submit del formulario.
		});
		  
		});
    </script>
   
    
</body>
</html>